package com.panda.zgqc.app.controller;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.panda.zgqc.app.domain.OrchardGardenRelation;
import com.panda.zgqc.app.service.IOrchardGardenRelationService;
import com.panda.common.entity.AjaxResult;
import com.panda.common.entity.PageEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.Collections;

@RestController
@RequestMapping("/app/orchard/garden/relation")
public class OrchardGardenRelationController {
    @Autowired
    private IOrchardGardenRelationService orchardGardenRelationService;

    @GetMapping("/page")
    public AjaxResult page(PageEntity pageEntity, OrchardGardenRelation orchardGardenRelation) {
        return AjaxResult.success(orchardGardenRelationService.page(pageEntity.toPage(), Wrappers.lambdaQuery(orchardGardenRelation)));
    }

    @GetMapping("/list")
    public AjaxResult list(OrchardGardenRelation orchardGardenRelation) {
        return AjaxResult.success(orchardGardenRelationService.list(Wrappers.lambdaQuery(orchardGardenRelation)));
    }

    @PostMapping("/push")
    public AjaxResult add(@RequestBody OrchardGardenRelation orchardGardenRelation) {
        return AjaxResult.success(orchardGardenRelationService.save(orchardGardenRelation));
    }

    @PutMapping("/edit")
    public AjaxResult edit(@RequestBody OrchardGardenRelation orchardGardenRelation) {
        return AjaxResult.success(orchardGardenRelationService.updateById(orchardGardenRelation));
    }

    @DeleteMapping("/delete/{ids}")
    public AjaxResult delete(@PathVariable Long[] ids) {
        return AjaxResult.success(orchardGardenRelationService.removeByIds(Collections.singletonList(ids)));
    }

    @GetMapping(value = "/detail/{id}")
    public AjaxResult detail(@PathVariable("id") Long id) {
        return AjaxResult.success(orchardGardenRelationService.getById(id));
    }
}
