package com.panda.zgqc.app.controller;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.panda.zgqc.app.domain.PurchaseBill;
import com.panda.zgqc.app.service.IPurchaseBillService;
import com.panda.common.entity.AjaxResult;
import com.panda.common.entity.PageEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.Collections;

@RestController
@RequestMapping("/app/purchase/bill")
public class PurchaseBillController {
    @Autowired
    private IPurchaseBillService purchaseBillService;

    @GetMapping("/page")
    public AjaxResult page(PageEntity pageEntity, PurchaseBill purchaseBill) {
        return AjaxResult.success(purchaseBillService.page(pageEntity.toPage(), Wrappers.lambdaQuery(purchaseBill)));
    }

    @GetMapping("/list")
    public AjaxResult list(PurchaseBill purchaseBill) {
        return AjaxResult.success(purchaseBillService.list(Wrappers.lambdaQuery(purchaseBill)));
    }

    @PostMapping("/push")
    public AjaxResult add(@RequestBody PurchaseBill purchaseBill) {
        return AjaxResult.success(purchaseBillService.save(purchaseBill));
    }

    @PutMapping("/edit")
    public AjaxResult edit(@RequestBody PurchaseBill purchaseBill) {
        return AjaxResult.success(purchaseBillService.updateById(purchaseBill));
    }

    @DeleteMapping("/delete/{ids}")
    public AjaxResult delete(@PathVariable Long[] ids) {
        return AjaxResult.success(purchaseBillService.removeByIds(Collections.singletonList(ids)));
    }

    @GetMapping(value = "/detail/{id}")
    public AjaxResult detail(@PathVariable("id") Long id) {
        return AjaxResult.success(purchaseBillService.getById(id));
    }
}
