package com.panda.zgqc.app.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Objects;

/**
 * 商标时间开启范围
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@TableName(value = "t_author_time_item")
public class AuthorTimeItem {
    private static final long serialVersionUID = 1L;
    /**
     * 主键
     */
    @TableId(type = IdType.AUTO)
    private Long id;
    /**
     * 系统Id
     */
    private String sysId;
    /**
     * 组织id
     */
    private String organizationId;
    /**
     * 操作人
     */
    private String operator;
    /**
     * 创建时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime createTime;
    /**
     * 修改时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime updateTime;
    /**
     * 修改人
     */
    private String operatorName;
    /**
     * 授权开始时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd")
    private LocalDate authStartTime;
    /**
     * 授权截止时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd")
    private LocalDate authEndTime;
    /**
     * 当前选择年份
     */
    private String currentAuthYear;

    public AuthorTimeItem(AuthorTimeItem authorTimeItem) {
        if (Objects.nonNull(authorTimeItem)) {
            this.id = authorTimeItem.id;
            this.sysId = authorTimeItem.sysId;
            this.organizationId = authorTimeItem.organizationId;
            this.operator = authorTimeItem.operator;
            this.createTime = authorTimeItem.createTime;
            this.updateTime = authorTimeItem.updateTime;
            this.operatorName = authorTimeItem.operatorName;
            this.authStartTime = authorTimeItem.authStartTime;
            this.authEndTime = authorTimeItem.authEndTime;
            this.currentAuthYear = authorTimeItem.currentAuthYear;
        }
    }
}
