package com.panda.zgqc.app.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Objects;

/**
 * 授权时间
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@TableName(value = "t_authorization_list_time_scope")
public class AuthorizationListimeScope {
    private static final long serialVersionUID = 1L;
    /**
     * 主键
     */
    @TableId(type = IdType.AUTO)
    private Long id;
    /**
     * 系统Id
     */
    private String sysId;
    /**
     * 组织id
     */
    private String organizationId;
    /**
     * 操作人
     */
    private String operator;
    /**
     * 创建时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime createTime;
    /**
     * 修改时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime updateTime;
    /**
     * 修改人
     */
    private String operatorName;
    /**
     * 开始时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd")
    private LocalDate startTime;
    /**
     * 结束时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd")
    private LocalDate endTime;
    /**
     * 部门id
     */
    private String departmentId;

    public AuthorizationListimeScope(AuthorizationListimeScope authorizationListimeScope) {
        if (Objects.nonNull(authorizationListimeScope)) {
            this.id = authorizationListimeScope.id;
            this.sysId = authorizationListimeScope.sysId;
            this.organizationId = authorizationListimeScope.organizationId;
            this.operator = authorizationListimeScope.operator;
            this.createTime = authorizationListimeScope.createTime;
            this.updateTime = authorizationListimeScope.updateTime;
            this.operatorName = authorizationListimeScope.operatorName;
            this.startTime = authorizationListimeScope.startTime;
            this.endTime = authorizationListimeScope.endTime;
            this.departmentId = authorizationListimeScope.departmentId;
        }
    }
}
