package com.panda.zgqc.app.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.time.LocalDateTime;
import java.util.Objects;

/**
 * 电子合同签署回调
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@TableName(value = "t_contract_sign_callback")
public class ContracsignCallback {
    private static final long serialVersionUID = 1L;
    @TableId(type = IdType.AUTO)
    private Long id;
    private String action;
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime actionTime;
    private String signFlowId;
    private String custombiznum;
    /**
     * 创建时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime createTime;
    /**
     * 更新时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime updateTime;
    private String content;

    public ContracsignCallback(ContracsignCallback contracsignCallback) {
        if (Objects.nonNull(contracsignCallback)) {
            this.id = contracsignCallback.id;
            this.action = contracsignCallback.action;
            this.actionTime = contracsignCallback.actionTime;
            this.signFlowId = contracsignCallback.signFlowId;
            this.custombiznum = contracsignCallback.custombiznum;
            this.createTime = contracsignCallback.createTime;
            this.updateTime = contracsignCallback.updateTime;
            this.content = contracsignCallback.content;
        }
    }
}
