package com.panda.zgqc.app.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.time.LocalDateTime;
import java.util.Objects;

/**
 * 病虫害-概览
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@TableName(value = "t_disease_pest_outline")
public class DiseasePesoutline {
    private static final long serialVersionUID = 1L;
    /**
     * 主键
     */
    @TableId(type = IdType.AUTO)
    private Long id;
    /**
     * 创建时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime createTime;
    /**
     * 更新时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime updateTime;
    /**
     * 病虫害编号
     */
    private String diseasePestCode;
    /**
     * 典型图片链接
     */
    private String typicalImg;
    /**
     * 危害状图片
     */
    private String harmStateImges;
    /**
     * 特征
     */
    private String characteristic;
    /**
     * 周期
     */
    private String cycle;
    /**
     * 条件
     */
    private String condition;
    /**
     * 类型：D 为病害, P 为虫害,N 天敌，G 草害，X 生理性病害
     */
    private String type;
    private String outlineJson;

    public DiseasePesoutline(DiseasePesoutline diseasePesoutline) {
        if (Objects.nonNull(diseasePesoutline)) {
            this.id = diseasePesoutline.id;
            this.createTime = diseasePesoutline.createTime;
            this.updateTime = diseasePesoutline.updateTime;
            this.diseasePestCode = diseasePesoutline.diseasePestCode;
            this.typicalImg = diseasePesoutline.typicalImg;
            this.harmStateImges = diseasePesoutline.harmStateImges;
            this.characteristic = diseasePesoutline.characteristic;
            this.cycle = diseasePesoutline.cycle;
            this.condition = diseasePesoutline.condition;
            this.type = diseasePesoutline.type;
            this.outlineJson = diseasePesoutline.outlineJson;
        }
    }
}
