package com.panda.zgqc.app.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.time.LocalDateTime;
import java.util.Objects;

/**
 * 用工评价
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@TableName(value = "t_evaluation")
public class Evaluation {
    private static final long serialVersionUID = 1L;
    /**
     * 主键Id
     */
    @TableId(type = IdType.AUTO)
    private Long id;
    /**
     * 系统id
     */
    private String sysId;
    /**
     * 组织id
     */
    private String organizationId;
    /**
     * 创建时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime createTime;
    /**
     * 更新时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime updateTime;
    /**
     * 评价事件ID
     */
    private String businessId;
    /**
     * 评价事件类型 1:找用工 2:找服务 3销售服务 4溯源评价
     */
    private Integer businessType;
    /**
     * 评价方Id
     */
    private String evaluatorId;
    /**
     * 评价方身份  1:用工方 2:服务方 3:市场主体方 4:需求方
     */
    private String evaluatorRole;
    /**
     * 评价方姓名
     */
    private String evaluatorName;
    /**
     * 被评价方Id
     */
    private String evaluatedId;
    /**
     * 评分(星级) 1-5分
     */
    private Integer score;
    /**
     * 被评价方姓名
     */
    private String evaluatedName;
    /**
     * 评价内容
     */
    private String content;
    /**
     * 评价图片
     */
    private String image;
    /**
     * 删除状态 1:未删除 0:已删除
     */
    private Integer deleteStatus;

    public Evaluation(Evaluation evaluation) {
        if (Objects.nonNull(evaluation)) {
            this.id = evaluation.id;
            this.sysId = evaluation.sysId;
            this.organizationId = evaluation.organizationId;
            this.createTime = evaluation.createTime;
            this.updateTime = evaluation.updateTime;
            this.businessId = evaluation.businessId;
            this.businessType = evaluation.businessType;
            this.evaluatorId = evaluation.evaluatorId;
            this.evaluatorRole = evaluation.evaluatorRole;
            this.evaluatorName = evaluation.evaluatorName;
            this.evaluatedId = evaluation.evaluatedId;
            this.score = evaluation.score;
            this.evaluatedName = evaluation.evaluatedName;
            this.content = evaluation.content;
            this.image = evaluation.image;
            this.deleteStatus = evaluation.deleteStatus;
        }
    }
}
