package com.panda.zgqc.app.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Objects;

/**
 * 用工信息
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@TableName(value = "t_labor_hire_info")
public class LaborHireInfo {
    private static final long serialVersionUID = 1L;
    /**
     * Id
     */
    @TableId(type = IdType.AUTO)
    private Long id;
    /**
     * 系统id
     */
    private String sysId;
    /**
     * 组织id
     */
    private String organizationId;
    /**
     * 创建时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime createTime;
    /**
     * 更新时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime updateTime;
    /**
     * 用工需求Id
     */
    private String laborHireId;
    /**
     * 发布人ID
     */
    private String publisherId;
    /**
     * 发布人
     */
    private String publisherName;
    /**
     * 用工标题
     */
    private String title;
    /**
     * 用工人数
     */
    private Integer personCount;
    /**
     * 联系电话
     */
    private String contactPhone;
    /**
     * 工资类型 1:日薪 2:月薪 3:面议
     */
    private Integer salaryType;
    /**
     * 工资金额
     */
    private BigDecimal salaryMoney;
    /**
     * 工作日期范围
     */
    private String workDateRange;
    /**
     * 工作时间范围
     */
    private String workTimeRange;
    /**
     * 工作地点
     */
    private String workAddress;
    /**
     * 薪资说明
     */
    private String salaryIntroduce;
    /**
     * 工作内容描述
     */
    private String contentIntroduce;
    /**
     * 用工需求状态 1:进行中 2:已完成 3:已取消
     */
    private Integer laborHireStatus;
    /**
     * 关闭时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime closeTime;

    public LaborHireInfo(LaborHireInfo laborHireInfo) {
        if (Objects.nonNull(laborHireInfo)) {
            this.id = laborHireInfo.id;
            this.sysId = laborHireInfo.sysId;
            this.organizationId = laborHireInfo.organizationId;
            this.createTime = laborHireInfo.createTime;
            this.updateTime = laborHireInfo.updateTime;
            this.laborHireId = laborHireInfo.laborHireId;
            this.publisherId = laborHireInfo.publisherId;
            this.publisherName = laborHireInfo.publisherName;
            this.title = laborHireInfo.title;
            this.personCount = laborHireInfo.personCount;
            this.contactPhone = laborHireInfo.contactPhone;
            this.salaryType = laborHireInfo.salaryType;
            this.salaryMoney = laborHireInfo.salaryMoney;
            this.workDateRange = laborHireInfo.workDateRange;
            this.workTimeRange = laborHireInfo.workTimeRange;
            this.workAddress = laborHireInfo.workAddress;
            this.salaryIntroduce = laborHireInfo.salaryIntroduce;
            this.contentIntroduce = laborHireInfo.contentIntroduce;
            this.laborHireStatus = laborHireInfo.laborHireStatus;
            this.closeTime = laborHireInfo.closeTime;
        }
    }
}
