package com.panda.zgqc.app.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.time.LocalDateTime;
import java.util.Objects;

/**
 * 其他相关主体信息
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@TableName(value = "t_other_related_subject_information")
public class OtherRelatedSubjecinformation {
    private static final long serialVersionUID = 1L;
    /**
     * 自增id
     */
    @TableId(type = IdType.AUTO)
    private Long id;
    /**
     * 相关主体名称
     */
    private String otherSubjectName;
    /**
     * 社会信用统一代码
     */
    private String socUnifiedCreditCode;
    /**
     * 社会主体类型
     */
    private String otherSubjectType;
    /**
     * 产业规模
     */
    private String industrialScale;
    /**
     * 位置
     */
    private String location;
    /**
     * 经度
     */
    private String longitude;
    /**
     * 纬度
     */
    private String latitude;
    /**
     * 联系人
     */
    private String contactMan;
    /**
     * 联系方式
     */
    private String contactNumber;
    /**
     * 备注
     */
    private String remarks;
    /**
     * 操作时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime operateTime;
    /**
     * 是否删除  1-未删除  0-已删除
     */
    private Integer deleted;
    /**
     * 创建时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime createTime;
    /**
     * 更新时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime updateTime;
    /**
     * 组织id
     */
    private String organizationId;
    /**
     * 系统id
     */
    private String sysId;

    public OtherRelatedSubjecinformation(OtherRelatedSubjecinformation otherRelatedSubjecinformation) {
        if (Objects.nonNull(otherRelatedSubjecinformation)) {
            this.id = otherRelatedSubjecinformation.id;
            this.otherSubjectName = otherRelatedSubjecinformation.otherSubjectName;
            this.socUnifiedCreditCode = otherRelatedSubjecinformation.socUnifiedCreditCode;
            this.otherSubjectType = otherRelatedSubjecinformation.otherSubjectType;
            this.industrialScale = otherRelatedSubjecinformation.industrialScale;
            this.location = otherRelatedSubjecinformation.location;
            this.longitude = otherRelatedSubjecinformation.longitude;
            this.latitude = otherRelatedSubjecinformation.latitude;
            this.contactMan = otherRelatedSubjecinformation.contactMan;
            this.contactNumber = otherRelatedSubjecinformation.contactNumber;
            this.remarks = otherRelatedSubjecinformation.remarks;
            this.operateTime = otherRelatedSubjecinformation.operateTime;
            this.deleted = otherRelatedSubjecinformation.deleted;
            this.createTime = otherRelatedSubjecinformation.createTime;
            this.updateTime = otherRelatedSubjecinformation.updateTime;
            this.organizationId = otherRelatedSubjecinformation.organizationId;
            this.sysId = otherRelatedSubjecinformation.sysId;
        }
    }
}
