import request from "@/utils/request";
export function fetchList(params) {
  return request({
    url: "/product/list",
    method: "get",
    params: params
  });
}

export function fetchSimpleList(params) {
  return request({
    url: "/product/simpleList",
    method: "get",
    params: params
  });
}

export function updateDeleteStatus(params) {
  return request({
    url: "/product/update/deleteStatus",
    method: "post",
    params: params
  });
}

export function updateNewStatus(params) {
  return request({
    url: "/product/update/newStatus",
    method: "post",
    params: params
  });
}

export function updateRecommendStatus(params) {
  return request({
    url: "/product/update/recommendStatus",
    method: "post",
    params: params
  });
}

export function updatePublishStatus(params) {
  return request({
    url: "/product/update/publishStatus",
    method: "post",
    params: params
  });
}

export function createProduct(data) {
  return request({
    url: "/product/create",
    method: "post",
    data: data
  });
}

export function updateProduct(id, data) {
  return request({
    url: "/product/update/" + id,
    method: "post",
    data: data
  });
}

export function getProduct(id) {
  return request({
    url: "/product/updateInfo/" + id,
    method: "get"
  });
}
// ------------------------------------------------------------------------------------
//底下的是新增的api，上面的是自带的
export function createUser(data) {
  //学员页新建线索
  console.log(data, "createUser");
  return request({
    url: "/user/info/add",
    method: "post",
    data: data
  });
}

export function getUserInfo(id) {
  // 学员详情页查询基本信息
  return request({
    url: `/user/info/selectOne/${id}`,
    method: "post"
  });
}

export function UserInfoDetail(id) {
  // 学员详情页查询用户基本信息详情
  return request({
    url: `/user/info/detail/${id}`,
    method: "post"
  });
}

export function UserInfoUpdate(data) {
  // 学员详情页修改用户基本信息详情
  return request({
    url: `/user/info/update`,
    method: "post",
    data
  });
}

export function addChatRecord(data) {
  //学员详情页添加沟通记录
  return request({
    url: "/chat/record/add",
    method: "post",
    data: data
  });
}

export function getChatRecordAll(data) {
  //获取学员详情页沟通记录
  return request({
    url: "/chat/record/all",
    method: "post",
    data: data
  });
}

export function getTodayTasks() {
  //首页获取今日任务
  return request({
    url: "/customerCare/user/statistics/todayTask",
    ///customerCare/user/statistics/todayTask
    method: "post"
  });
}

export function getNotice(data) {
  //首页获取系统公告
  return request({
    url: "/notice/list",
    method: "post",
    data: data
  });
}

export function myStu(data) {
  //我的学员页。获取学员筛选结果
  return request({
    url: "/user/info/all/filter",
    method: "post",
    data: data
  });
}

export function userTag(id) {
  // 学员详情页查询用户标签
  return request({
    url: `/user/tag/all/${id}`,
    method: "post"
  });
}

export function addUserCustomTag(data) {
  // 学员详情页添加用户自定义标签
  return request({
    url: `/user/tag/addUserCustomTag`,
    method: "post",
    data
  });
}

export function deleteUserCustomTag(data) {
  // 学员详情页删除用户标签
  return request({
    url: `/user/tag/delete`,
    method: "post",
    data
  });
}

export function allTag(data) {
  // 我的标签页，标签统计
  return request({
    url: `/tag/Statistics/all`,
    method: "post",
    data
  });
}

export function singleTag(data) {
  // 我的标签页，客服-单一标签列表
  return request({
    url: `/tag/Statistics/customerCare/singleTag`,
    method: "post",
    data
  });
}

export function xuefuSingleTag(data) {
  // 我的标签页，学服-单一标签列表
  return request({
    url: `/tag/Statistics/studyCare/singleTag`,
    method: "post",
    data
  });
}

export function deleteList(data) {
  // 单一标签页，批量删除单一标签下的用户
  return request({
    url: `/tag/Statistics/deleteList`,
    method: "post",
    data
  });
}

export function newAddClew(data) {
  // 首页点击跳转新增线索 待沟通线索
  return request({
    url: `/today/info/newAddClew`,
    method: "post",
    data
  });
}

export function newAddStu(data) {
  // 首页点击跳转新增学员
  return request({
    url: `/today/info/addUser`,
    method: "post",
    data
  });
}

export function newChatUser(data) {
  // 首页点击跳转已沟通学员
  return request({
    url: `/today/info/chatUser`,
    method: "post",
    data
  });
}

export function newUnChatUser(data) {
  // 首页点击跳转已沟通学员
  return request({
    url: `/today/info/unChatUser`,
    method: "post",
    data
  });
}

export function KPI(data) {
  // cso首页业绩简报
  return request({
    url: `/customerCare/user/statistics/KPI`,
    method: "post",
    data
  });
}

export function auditCommitNum(data) {
  // cso首页业绩简报-审课提交数
  return request({
    url: `/studyCare/user/statistics/auditCommitNum`,
    method: "post",
    data
  });
}

export function refundNum(data) {
  // cso首页业绩简报-退费人数
  return request({
    url: `/studyCare/user/statistics/refundNum`,
    method: "post",
    data
  });
}

export function statisticsLop(data) {
  // cso首页业绩简报-LOP审核通过人数
  return request({
    url: `/studyCare/user/statistics/Lop`,
    method: "post",
    data
  });
}

export function kpiList(data) {
  // 业绩简报详情列表
  return request({
    url: `/kpi/statistics/detail/list`,
    method: "post",
    data
  });
}

export function unPayBalance(data) {
  // 业绩简报未补全尾款
  return request({
    url: `/kpi/statistics/unPayBalance`,
    method: "post",
    data
  });
}

export function payCostInfoAll(data) {
  // 学员详情页-分页查询缴费记录
  return request({
    url: `/payCost/record/all`,
    method: "post",
    data
  });
}

// ----------------------------------------------------------------------
// 学服部接口

export function todayTask(data) {
  // 学服-首页今日任务
  return request({
    url: `/studyCare/user/statistics/todayTask`,
    method: "post",
    data
  });
}

export function lop(data) {
  // 学服-首页LOP审核通过人数
  return request({
    url: `/studyCare/user/statistics/Lop`,
    method: "post",
    data
  });
}

export function newAllocate(data) {
  // 学服-首页今日任务查询新分配学员
  return request({
    url: `/confirm/user/base/search/newAllocate`,
    method: "post",
    data
  });
}

export function addWechatStatus(data) {
  // 学服-首页今日任务-修改主动添加微信状态
  return request({
    url: `/confirm/user/base/update/addWechat/status`,
    method: "post",
    data
  });
}

export function weChatState(id) {
  // 学服-首页今日任务查询新分配学员-添加微信状态确认
  return request({
    url: `/confirm/user/base/update/weChatState/${id}`,
    method: "post"
  });
}

export function unConfirmBase(data) {
  // 学服-首页今日任务-查询基本信息待确认
  return request({
    url: `/confirm/user/base/search/unConfirmBase`,
    method: "post",
    data
  });
}

export function single(id) {
  // 学服-首页今日任务-基本信息待确认-查询单一学员基本待确认信息
  return request({
    url: `/confirm/user/base/search/single/${id}`,
    method: "post"
  });
}

export function picUrl(data) {
  // 学服-首页今日任务-查询基本信息待确认-变更用户图片
  return request({
    url: `/confirm/user/base/update/picUrl`,
    method: "post",
    data
  });
}

export function baseConfirmState(id) {
  // 学服-首页今日任务-基本信息待确认-基本信息审课完成
  return request({
    url: `/confirm/user/base/update/baseConfirmState/${id}`,
    method: "post"
  });
}

export function addCourse(data) {
  // 学员详情页-课程信息-添加课程
  return request({
    url: `/user/course/addCourse`,
    method: "post",
    data
  });
}

export function allCode(data) {
  // 学员详情页-课程信息-查询cso课程代码
  return request({
    url: `/cso/all`,
    method: "post",
    data
  });
}

export function allPayCode(data) {
  // 学员详情页-课程信息-查询缴费标签
  return request({
    url: `/payCost/tag/all`,
    method: "post",
    data
  });
}

export function courseList(data) {
  // 学员详情页-课程信息-课程信息分页展示
  return request({
    url: `/user/course/list`,
    method: "post",
    data
  });
}

export function editUpdate(data) {
  // 学员详情页-课程信息-修改用户课程
  return request({
    url: `/user/course/update`,
    method: "post",
    data
  });
}

export function deleteCourse(id) {
  // 学员详情页-课程信息-删除用户课程
  return request({
    url: `/user/course/delete/${id}`,
    method: "post"
  });
}

export function updateAuditCourse(data) {
  // 学员详情页-课程信息-修改审课信息
  return request({
    url: `/user/course/updateAuditCourse`,
    method: "post",
    data
  });
}

export function addCurrentTermCourse(data) {
  // 学员详情页-课程信息-继续添加本期课程
  return request({
    url: `/user/course/addCurrentTermCourse`,
    method: "post",
    data
  });
}

export function addPayCost(data) {
  // 学员详情页-缴费信息-添加缴费记录
  return request({
    url: `/payCost/record/add`,
    method: "post",
    data
  });
}

export function updatePayCost(data) {
  // 学员详情页-缴费信息-修改缴费记录
  return request({
    url: `/payCost/record/update`,
    method: "post",
    data
  });
}

export function outlineList(data) {
  // 大纲页-查询课程大纲
  return request({
    url: `/course/outline/list`,
    method: "post",
    data
  });
}

export function updateOutlineState(id) {
  // 大纲页-查询课程大纲-课程大纲确认
  return request({
    url: `/course/outline/updateState/${id}`,
    method: "post"
  });
}

export function statistics(data) {
  // 学服部主管首页-数据简报
  return request({
    url: `/teacherAssistant/user/statistics/statistics`,
    method: "post",
    data
  });
}

export function xfSelectUnBind(data) {
  // 学服部主管-我的学员-查询待分配学员
  return request({
    url: `/studyCare/allocate/selectUnBind`,
    method: "post",
    data
  });
}

export function kfSelectUnBind(data) {
  // 客服部主管-我的学员-查询待分配学员
  return request({
    url: `/customerCare/allocate/selectUnBind`,
    method: "post",
    data
  });
}

export function adminList(state) {
  // 学服部主管-我的学员-查询老师(state = 1客服，state = 2学服))
  return request({
    url: `/filter/param/adminList/${state}`,
    method: "post"
  });
}

export function xfUpdateAllocate(data) {
  // 学服部主管-我的学员-分配学员到指定学服
  return request({
    url: `/studyCare/allocate/update`,
    method: "post",
    data
  });
}
export function kfUpdateAllocate(data) {
  // 客服部主管-我的学员-分配学员到指定客服
  return request({
    url: `/customerCare/allocate/update`,
    method: "post",
    data
  });
}

export function xfSelectBind(data) {
  // 学服部主管-我的学员-查询已分配学员
  return request({
    url: `/studyCare/allocate/selectBind`,
    method: "post",
    data
  });
}

export function kfSelectBind(data) {
  // 客服部主管-我的学员-查询已分配学员
  return request({
    url: `/customerCare/allocate/selectBind`,
    method: "post",
    data
  });
}

export function noticeAll(data) {
  // 学服部主管-系统公告-分页查询系统公告
  return request({
    url: `/system/notice/all`,
    method: "post",
    data
  });
}

export function addNoticeAll(data) {
  // 学服部主管-系统公告-添加系统公告
  return request({
    url: `/system/notice/add`,
    method: "post",
    data
  });
}

export function deleteNotice(id) {
  // 学服部主管-系统公告-删除系统公告
  return request({
    url: `/system/notice/delete/${id}`,
    method: "post"
  });
}
export function updateNoticeAll(data) {
  // 学服部主管-系统公告-修改系统公告
  return request({
    url: `/system/notice/update`,
    method: "post",
    data
  });
}

export function xuefuMasterAllStu(data) {
  // 学服部主管-全部学员
  return request({
    url: `/course/filter/all`,
    method: "post",
    data
  });
}

export function school(data) {
  // 学服部主管-全部学员-学校列表
  return request({
    url: `/filter/param/school`,
    method: "post",
    data
  });
}
export function courseTime(data) {
  // 学服部主管-全部学员-报名学期列表
  return request({
    url: `/filter/param/courseTime`,
    method: "post",
    data
  });
}

export function selectCourse(state, data) {
  // 今日任务-审课待分配-根据条件查询(待确认/审课中、审课通过/审课未通过)课程信息
  return request({
    url: `/course/filter/list/selectCourse/${state}`,
    method: "post",
    data
  });
}

export function confirmCourse(data) {
  // 今日任务-审课待分配-确认课程
  return request({
    url: `/course/filter/confirmCourse`,
    method: "post",
    data
  });
}

export function LOPState(data) {
  // 今日任务-审课待分配-LOP确认
  return request({
    url: `/course/filter/LOPState`,
    method: "post",
    data
  });
}

export function unPassState(data) {
  // 今日任务-审课待分配-审课未通过确认
  return request({
    url: `/course/filter/unPassState`,
    method: "post",
    data
  });
}

export function auditFail(data) {
  // 审课进行中-查询审课失败信息
  return request({
    url: `/course/filter/list/auditFail`,
    method: "post",
    data
  });
}

export function unConfirmAuditCourse1(state, data) {
  // 审课进行中-查询全部信息待确认/转学分待确认学员
  return request({
    url: `/course/filter/list/unConfirmAuditCourse/${state}`,
    method: "post",
    data
  });
}

export function confirmAuditCourseState1(data) {
  // 审课进行中-全部信息确认/转学分确认
  return request({
    url: `/course/filter/confirmAuditCourseState`,
    method: "post",
    data
  });
}

export function confirmAuditCourseState2(data) {
  // 审课进行中-全部信息确认/转学分确认
  return request({
    url: `/course/filter/confirmAuditCourseState`,
    method: "post",
    data
  });
}

export function unConfirmAuditCourse2(state, data) {
  // 审课进行中-查询全部信息待确认/转学分待确认学员
  return request({
    url: `/course/filter/list/unConfirmAuditCourse/${state}`,
    method: "post",
    data
  });
}

export function userAuditCourseState(data) {
  // 学员详情-学员审课所处状态
  return request({
    url: `/user/course/auditCourseState`,
    method: "post",
    data
  });
}

export function proofPic(id) {
  // 学员详情-查询用户上传凭证
  return request({
    url: `/user/info/proofPic/${id}`,
    method: "post"
  });
}

export function unCommit(data) {
  // 学员详情-查询未提交信息审核
  return request({
    url: `/confirm/user/base/search/unCommit`,
    method: "post",
    data
  });
}

export function channel(data) {
  // 客服部首页-销售渠道占比
  return request({
    url: `/customerCare/user/statistics/channel`,
    method: "post",
    data
  });
}

export function statisticsList(data) {
  // 数据统计-招生院校统计
  return request({
    url: `/auditSchool/statistics/list`,
    method: "post",
    data
  });
}

export function payCostTagAll(data) {
  // 缴费标签-分页查询缴费标签
  return request({
    url: `/payCost/tag/all`,
    method: "post",
    data
  });
}

export function payCostTagAdd(data) {
  // 缴费标签-添加缴费标签
  return request({
    url: `/payCost/tag/add`,
    method: "post",
    data
  });
}

export function payCostTagUpdate(data) {
  // 缴费标签-修改缴费标签
  return request({
    url: `/payCost/tag/update`,
    method: "post",
    data
  });
}
export function adminAllUser(data) {
  // 学员-管理员查询全部学员
  return request({
    url: `/all/user/data/search`,
    method: "post",
    data
  });
}

// 教务部

export function getProfessors(data) {
  // 教务部主管-需匹配教授
  return request({
    url: `/teacherAssistant/user/statistics/todayTask`,
    method: "post",
    data
  });
}
export function getPFSta(data) {
  // 教务部主管-数据简报
  return request({
    url: `/teacherAssistant/user/statistics/statistics`,
    method: "post",
    data
  });
}

// 教务部接口转移到cso2.js
