import request from "@/utils/request";
export function fetchList(params) {
  return request({
    url: "/product/list",
    method: "get",
    params: params
  });
}

export function fetchSimpleList(params) {
  return request({
    url: "/product/simpleList",
    method: "get",
    params: params
  });
}

export function updateDeleteStatus(params) {
  return request({
    url: "/product/update/deleteStatus",
    method: "post",
    params: params
  });
}

export function updateNewStatus(params) {
  return request({
    url: "/product/update/newStatus",
    method: "post",
    params: params
  });
}

export function updateRecommendStatus(params) {
  return request({
    url: "/product/update/recommendStatus",
    method: "post",
    params: params
  });
}

export function updatePublishStatus(params) {
  return request({
    url: "/product/update/publishStatus",
    method: "post",
    params: params
  });
}

export function createProduct(data) {
  return request({
    url: "/product/create",
    method: "post",
    data: data
  });
}

export function updateProduct(id, data) {
  return request({
    url: "/product/update/" + id,
    method: "post",
    data: data
  });
}

export function getProduct(id) {
  return request({
    url: "/product/updateInfo/" + id,
    method: "get"
  });
}
// ------------------------------------------------------------------------------------
//底下的是新增的api，上面的是自带的
export function createUser(data) {
  //学员页新建线索
  console.log(data, "createUser");
  return request({
    url: "/user/info/add",
    method: "post",
    data: data
  });
}

export function getUserInfo(id) {
  // 学员详情页查询基本信息
  return request({
    url: `/user/info/selectOne/${id}`,
    method: "post"
  });
}

export function UserInfoDetail(id) {
  // 学员详情页查询用户基本信息详情
  return request({
    url: `/user/info/detail/${id}`,
    method: "post"
  });
}

export function UserStatusUpdate(data) {
  // 学员详情页修改学员状态
  return request({
    url: `/user/info/updateUserStatus`,
    method: "post",
    data
  });
}


export function UserInfoUpdate(data) {
  // 学员详情页修改用户基本信息详情
  return request({
    url: `/user/info/update`,
    method: "post",
    data
  });
}

export function addChatRecord(data) {
  //学员详情页添加沟通记录
  return request({
    url: "/chat/record/add",
    method: "post",
    data: data
  });
}

export function getChatRecordAll(data) {
  //获取学员详情页沟通记录
  return request({
    url: "/chat/record/all",
    method: "post",
    data: data
  });
}

export function getTodayTasks() {
  //首页获取今日任务
  return request({
    url: "/customerCare/user/statistics/todayTask",
    ///customerCare/user/statistics/todayTask
    method: "post"
  });
}

export function getNotice(data) {
  //首页获取系统公告
  return request({
    url: "/notice/list",
    method: "post",
    data: data
  });
}

export function myStu(data) {
  //我的学员页。获取学员筛选结果
  return request({
    url: "/user/info/all/filter",
    method: "post",
    data: data
  });
}

export function userTag(id) {
  // 学员详情页查询用户标签
  return request({
    url: `/user/tag/all/${id}`,
    method: "post"
  });
}

export function addUserCustomTag(data) {
  // 学员详情页添加用户自定义标签
  return request({
    url: `/user/tag/addUserCustomTag`,
    method: "post",
    data
  });
}

export function deleteUserCustomTag(data) {
  // 学员详情页删除用户标签
  return request({
    url: `/user/tag/delete`,
    method: "post",
    data
  });
}

export function allTag(data) {
  // 我的标签页，标签统计
  return request({
    url: `/tag/Statistics/all`,
    method: "post",
    data
  });
}

export function singleTag(data) {
  // 我的标签页，客服-单一标签列表
  return request({
    url: `/tag/Statistics/customerCare/singleTag`,
    method: "post",
    data
  });
}

export function deleteList(data) {
  // 单一标签页，批量删除单一标签下的用户
  return request({
    url: `/tag/Statistics/deleteList`,
    method: "post",
    data
  });
}

export function newAddClew(data) {
  // 首页点击跳转新增线索 待沟通线索
  return request({
    url: `/today/info/newAddClew`,
    method: "post",
    data
  });
}

export function newAddStu(data) {
  // 首页点击跳转新增学员
  return request({
    url: `/today/info/addUser`,
    method: "post",
    data
  });
}

export function newChatUser(data) {
  // 首页点击跳转已沟通学员
  return request({
    url: `/today/info/chatUser`,
    method: "post",
    data
  });
}

export function newUnChatUser(data) {
  // 首页点击跳转已沟通学员
  return request({
    url: `/today/info/unChatUser`,
    method: "post",
    data
  });
}

export function KPI(data) {
  // 首页业绩简报
  return request({
    url: `/customerCare/user/statistics/KPI`,
    method: "post",
    data
  });
}

export function kpiList(data) {
  // 业绩简报详情列表
  return request({
    url: `/kpi/statistics/detail/list`,
    method: "post",
    data
  });
}

export function unPayBalance(data) {
  // 业绩简报未补全尾款
  return request({
    url: `/kpi/statistics/unPayBalance`,
    method: "post",
    data
  });
}

export function payCostInfoAll(data) {
  // 学员详情页-分页查询缴费记录
  return request({
    url: `/payCost/record/all`,
    method: "post",
    data
  });
}

// ----------------------------------------------------------------------
// 学服部接口

export function todayTask(data) {
  // 学服-首页今日任务
  return request({
    url: `/studyCare/user/statistics/todayTask`,
    method: "post",
    data
  });
}

export function lop(data) {
  // 学服-首页LOP审核通过人数
  return request({
    url: `/studyCare/user/statistics/Lop`,
    method: "post",
    data
  });
}

export function newAllocate(data) {
  // 学服-首页今日任务查询新分配学员
  return request({
    url: `/confirm/user/base/search/newAllocate`,
    method: "post",
    data
  });
}

export function weChatState(id) {
  // 学服-首页今日任务查询新分配学员-添加微信状态确认
  return request({
    url: `/confirm/user/base/update/weChatState/${id}`,
    method: "post"
  });
}

export function unConfirmBase(data) {
  // 学服-首页今日任务-查询基本信息待确认
  return request({
    url: `/confirm/user/base/search/unConfirmBase`,
    method: "post",
    data
  });
}

export function single(id) {
  // 学服-首页今日任务-基本信息待确认-查询单一学员基本待确认信息
  return request({
    url: `/confirm/user/base/search/single/${id}`,
    method: "post"
  });
}

export function picUrl(data) {
  // 学服-首页今日任务-查询基本信息待确认-变更用户图片
  return request({
    url: `/confirm/user/base/update/picUrl`,
    method: "post",
    data
  });
}

export function baseConfirmState(id) {
  // 学服-首页今日任务-基本信息待确认-基本信息审课完成
  return request({
    url: `/confirm/user/base/update/baseConfirmState/${id}`,
    method: "post"
  });
}

export function addCourse(data) {
  // 学员详情页-课程信息-添加课程
  return request({
    url: `/user/course/addCourse`,
    method: "post",
    data
  });
}

export function allCode(data) {
  // 学员详情页-课程信息-查询cso课程代码
  return request({
    url: `/cso/all`,
    method: "post",
    data
  });
}
export function addCsoCode(data) {
  // 课程管理-cso课程管理-添加cso课程代码
  return request({
    url: `/cso/add`,
    method: "post",
    data
  });
}
export function updateCsoCode(data) {
  // 课程管理-cso课程管理-修改cso课程代码
  return request({
    url: `/cso/update`,
    method: "post",
    data
  });
}

export function allPayCode(data) {
  // 学员详情页-课程信息-查询缴费标签
  return request({
    url: `/payCost/tag/all`,
    method: "post",
    data
  });
}

export function courseList(data) {
  // 学员详情页-课程信息-课程信息分页展示
  return request({
    url: `/user/course/list`,
    method: "post",
    data
  });
}

export function editUpdate(data) {
  // 学员详情页-课程信息-修改用户课程
  return request({
    url: `/user/course/update`,
    method: "post",
    data
  });
}

export function deleteCourse(id) {
  // 学员详情页-课程信息-删除用户课程
  return request({
    url: `/user/course/delete/${id}`,
    method: "post"
  });
}

export function updateAuditCourse(data) {
  // 学员详情页-课程信息-修改审课信息
  return request({
    url: `/user/course/updateAuditCourse`,
    method: "post",
    data
  });
}

export function addCurrentTermCourse(data) {
  // 学员详情页-课程信息-继续添加本期课程
  return request({
    url: `/user/course/addCurrentTermCourse`,
    method: "post",
    data
  });
}

export function addPayCost(data) {
  // 学员详情页-缴费信息-添加缴费记录
  return request({
    url: `/payCost/record/add`,
    method: "post",
    data
  });
}

export function updatePayCost(data) {
  // 学员详情页-缴费信息-修改缴费记录
  return request({
    url: `/payCost/record/update`,
    method: "post",
    data
  });
}

export function outlineList(data) {
  // 大纲页-查询课程大纲
  return request({
    url: `/course/outline/list`,
    method: "post",
    data
  });
}

export function statistics(data) {
  // 学服部主管首页-数据简报
  return request({
    url: `/teacherAssistant/user/statistics/statistics`,
    method: "post",
    data
  });
}

export function selectUnBind(data) {
  // 学服部主管-我的学员-查询待分配学员
  return request({
    url: `/studyCare/allocate/selectUnBind`,
    method: "post",
    data
  });
}

export function adminList(state) {
  // 学服部主管-我的学员-查询老师(state = 1客服，state = 2学服,state =3 教务)))
  return request({
    url: `/filter/param/adminList/${state}`,
    method: "post"
  });
}

export function updateAllocate(data) {
  // 学服部主管-我的学员-分配学员到指定学服
  return request({
    url: `/studyCare/allocate/update`,
    method: "post",
    data
  });
}

export function selectBind(data) {
  // 学服部主管-我的学员-查询已分配学员
  return request({
    url: `/studyCare/allocate/selectBind`,
    method: "post",
    data
  });
}

export function noticeAll(data) {
  // 学服部主管-系统公告-分页查询系统公告
  return request({
    url: `/system/notice/all`,
    method: "post",
    data
  });
}

export function addNoticeAll(data) {
  // 学服部主管-系统公告-添加系统公告
  return request({
    url: `/system/notice/add`,
    method: "post",
    data
  });
}

export function deleteNotice(id) {
  // 学服部主管-系统公告-删除系统公告
  return request({
    url: `/system/notice/delete/${id}`,
    method: "post"
  });
}
export function updateNoticeAll(data) {
  // 学服部主管-系统公告-修改系统公告
  return request({
    url: `/system/notice/update`,
    method: "post",
    data
  });
}

export function xuefuMasterAllStu(data) {
  // 学服部主管-全部学员
  return request({
    url: `/course/filter/all`,
    method: "post",
    data
  });
}

export function school(data) {
  // 学服部主管-全部学员-学校列表
  return request({
    url: `/filter/param/school`,
    method: "post",
    data
  });
}
export function courseTime(data) {
  // 学服部主管-全部学员-上课年份列表
  return request({
    url: `/filter/param/courseTime`,
    method: "post",
    data
  });
}
export function auditSchool(data) {
  // 学服部主管-全部学员-审课学校
  return request({
    url: `/filter/param/auditSchool`,
    method: "post",
    data
  });
}

// 教务部

export function getProfessors(data) {
  // 教务部主管-首页-每日任务
  return request({
    url: `/teacherAssistant/user/statistics/todayTask`,
    method: "post",
    data
  });
}
export function getPFSta(data) {
  // 教务部主管-数据简报
  return request({
    url: `/teacherAssistant/user/statistics/statistics`,
    method: "post",
    data
  });
}

export function getNeedScoreStu(data) {
  // 教务部主管-需打分学员
  return request({
    url: `/course/gpa/selectUnGpa`,
    method: "post",
    data
  });
}
export function UpdateNeedScoreStu(data) {
  // 教务部主管-打分
  return request({
    url: `/course/gpa/add`,
    method: "post",
    data
  });
}
export function editScore(data) {
  // 教务部主管-编辑成绩
  return request({
    url: `/course/gpa/update`,
    method: "post",
    data
  });
}

export function addUSST(data) {
  // 教务部主管-添加USSTID
  return request({
    url: `/course/gpa/addUsstId`,
    method: "post",
    data
  });
}
export function getGpaOne(data) {
  // 教务部主管-一人单个学期成绩-打印模板
  return request({
    url: `/course/gpa/getOneGpa`,
    method: "post",
    data
  });
}

export function getTranscripts(userId) {
  // 教务部主管-查询成绩单
  return request({
    url: `/course/gpa/getGpa/${userId}`,
    method: "post",

  });
}


export function getHaveScoreStu(data) {
  // 教务部主管-已打分学员
  return request({
    url: `/course/gpa/selectGpa`,
    method: "post",
    data
  });
}
export function getStorePF(data) {
  // 教授管理-查询储备教授
  return request({
    url: `/match/professor/reserveProfessor/list`,
    method: "post",
    data
  });
}
export function getMatchPF(data) {
  // 教授管理-查询匹配教授
  return request({
    url: `/match/professor/professor/list`,
    method: "post",
    data
  });
}
export function getUpdatePF(data) {
  // 教授管理-添加修改储备、匹配教授
  return request({
    url: `/match/professor/updateProfessor`,
    method: "post",
    data
  });
}

export function getSchoolTypeAll(data) {
  // 院校管理-查询自主授课和非自主授课 type1和type2
  return request({
    url: `/audit/school/all`,
    method: "post",
    data
  });
}
export function getSchoolTypeAdd(data) {
  // 院校管理-添加自主授课和非自主授课 type1和type2
  return request({
    url: `/audit/school/add`,
    method: "post",
    data
  });
}
export function getSchoolTypeUpdate(data) {
  // 院校管理-修改自主授课和非自主授课 type1和type2
  return request({
    url: `/audit/school/update`,
    method: "post",
    data
  });
}

//合作院校页面-审课大学
export function cooperateSchoolAll(data) {
  // 合作院校查询
  return request({
    url: `/auditSchool/cso/all`,
    method: "post",
    data
  });
}
export function cooperateSchoolAdd(data) {
  // 合作院校添加
  return request({
    url: `/auditSchool/cso/add`,
    method: "post",
    data
  });
}
export function cooperateSchoolUpdate(data) {
  // 合作院校修改
  return request({
    url: `/auditSchool/cso/update`,
    method: "post",
    data
  });
}
export function cooperateSchoolDel(id) {
  // 合作院校删除
  return request({
    url: `/auditSchool/cso/delete/${id}`,
    method: "post",
  });
}

//招生大学-学生所在学校
export function recruitSchoolAll(data) {
  // 合作院校查询
  return request({
    url: `/school/cso/all`,
    method: "post",
    data
  });
}
export function recruitSchoolAdd(data) {
  // 合作院校添加
  return request({
    url: `/school/cso/add`,
    method: "post",
    data
  });
}
export function recruitSchoolUpdate(data) {
  // 合作院校修改
  return request({
    url: `/school/cso/update`,
    method: "post",
    data
  });
}
export function recruitSchoolDel(id) {
  // 合作院校删除
  return request({
    url: `/school/cso/delete/${id}`,
    method: "post"
  });
}

//教务部编撰大纲
export function csoOutline(data) {
  // 获取大纲
  return request({
    url: `/cso/outline/all`,
    method: "post",
    data
  });
}

export function UpdateCsoOutline(data) {
  // 更改进度
  return request({
    url: `/cso/outline/update`,
    method: "post",
    data
  });
}

export function ChangeCsoOutline(data) {
  // 转让大纲
  return request({
    url: `/cso/outline/updateBind`,
    method: "post",
    data
  });
}

export function fullNotice(data) {
  // 全服通知公告提醒
  return request({
    url: `/notice/remind`,
    method: "post",
    data
  });
}

export function fullNoticeList(data) {
  // 首页系统公告列表
  return request({
    url: `/notice/add/record`,
    method: "post",
    data
  });
}

export function getAuditSenior(data) {
  // lop审课中-下拉筛选审课学姐
  return request({
    url: `/filter/param/lop/auditSenior`,
    method: "post",
    data
  });
}

export function getCampusAgent(data) {
  // 业绩简报-下拉筛选校园大使
  return request({
    url: `/filter/param/campusAgent`,
    method: "post",
    data
  });
}