import Vue from "vue";

import "normalize.css/normalize.css"; // A modern alternative to CSS resets
import htmlToPdf from "@/utils/htmlToPdf"; //pdf插件
import ElementUI from "element-ui";
import "element-ui/lib/theme-chalk/index.css";
import locale from "element-ui/lib/locale/lang/zh-CN"; // lang i18n
import VCharts from "v-charts";

import "@/styles/index.scss"; // global css

import App from "./App";
import router from "./router";
import store from "./store";

import "@/icons"; // icon
import "@/permission"; // permission control

import moment from "moment";
import "moment/locale/zh-cn";
moment.locale("zh-cn");

// import Clipboard from "clipboard";
// Vue.prototype.Clipboard = Clipboard;

// Vue.prototype.$UPLOAD_BASE_URL = "https://pandaxuequ.com.cn/xs/admin"; //图片上传的服务器地址
// Vue.prototype.$UPLOAD_BASE_URL = "http://8.218.108.169:8057"; //图片上传的服务器地址
Vue.prototype.$UPLOAD_BASE_URL = process.env.BASE_API; //图片上传的服务器地址
// Vue.prototype.$H5_BASE_URL = "http://192.168.10.108:8081/#/"; //H5服务器地址
// Vue.prototype.$UPLOAD_BASE_URL = "http://test.csasedu.com:10032"; //图片上传的服务器地址
// Vue.prototype.$H5_BASE_URL = "http://test.csasedu.com:10034/#/"; //H5跳转的网页地址
Vue.prototype.$H5_BASE_URL = "http://8.218.108.169:10034/#/"; //H5跳转的网页地址
// Vue.prototype.$H5_BASE_URL = process.env.BASE_API + "/#/"; //H5跳转的网页地址

Vue.use(ElementUI, { locale });
Vue.use(VCharts);

Vue.use(htmlToPdf);

Vue.config.productionTip = false;

new Vue({
  el: "#app",
  router,
  store,
  template: "<App/>",
  components: { App }
});
