import Vue from "vue";
import Router from "vue-router";

Vue.use(Router);

/* Layout */
import Layout from "../views/layout/Layout";

/**
 * hidden: true                   if `hidden:true` will not show in the sidebar(default is false)
 * alwaysShow: true               if set true, will always show the root menu, whatever its child routes length
 *                                if not set alwaysShow, only more than one route under the children
 *                                it will becomes nested mode, otherwise not show the root menu
 * redirect: noredirect           if `redirect:noredirect` will no redirct in the breadcrumb
 * name:'router-name'             the name is used by <keep-alive> (must set!!!)
 * meta : {
    title: 'title'               the name show in submenu and breadcrumb (recommend set)
    icon: 'svg-name'             the icon show in the sidebar,
  }
 **/
export const constantRouterMap = [
  {
    path: "/login",
    component: () => import("@/views/login/index"),
    hidden: true
  },
  { path: "/404", component: () => import("@/views/404"), hidden: true },
  { path: "/h5", component: () => import("@/views/h5") },
  {
    path: "",
    component: Layout,
    redirect: "/home",
    children: [
      {
        path: "home",
        name: "home",
        component: () => import("@/views/home/index"),
        meta: { title: "首页", icon: "home" }
      }
    ]
  }
];

export const asyncRouterMap = [
  // 客服部主管所有页面
  {
    path: "/kfmhome",
    component: Layout,
    name: "kfmHome",
    redirect: "/kfmHome/kfm",
    meta: { title: "客服部主管首页", icon: "product" },
    children: [
      {
        path: "kfm",
        name: "kfm",
        component: () => import("@/views/kfmHome/index"),
        meta: { title: "客服主管首页", icon: "product-list" }
      },
      {
        path: "newclew",
        name: "newClew-kfm",
        component: () => import("@/views/dailyTask/newClew"),
        meta: { title: "待沟通线索", icon: "product-add" }
      },
      {
        path: "chatstu",
        name: "chatStu-kfm",
        component: () => import("@/views/dailyTask/chatStu"),
        meta: { title: "已沟通学员", icon: "product-add" }
      },
      {
        path: "newstu",
        name: "newStu-kfm",
        component: () => import("@/views/dailyTask/newStu"),
        meta: { title: "新增学员", icon: "product-add" }
      },

      {
        path: "unchatstu",
        name: "unChatStu-kfm",
        component: () => import("@/views/dailyTask/unChatStu"),
        meta: { title: "待沟通学员", icon: "product-add" }
      },
      {
        path: "kefumastermystu",
        name: "kefuMasterMyStu-kfm",
        component: () => import("@/views/pms/product/kefuMasterMyStu"),
        meta: { title: "客服主管我的学员", icon: "product-list" }
      },
      {
        path: "studetail",
        name: "stuDetail-kfm",
        component: () => import("@/views/pms/product/stuDetail"),
        meta: { title: "学员详情", icon: "product-add" }
      },
      {
        path: "kefuUnBind",
        name: "unBind-kfm",
        component: () => import("@/views/pms/product/kefuUnBind"),
        meta: { title: "待分配学员", icon: "product-add" }
      },
      {
        path: "kefuBind",
        name: "bind-kfm",
        component: () => import("@/views/pms/product/kefuBind"),
        meta: { title: "已分配学员", icon: "product-add" }
      },
      {
        path: "addproduct",
        name: "addProduct-kfm",
        component: () => import("@/views/pms/product/add"),
        meta: { title: "新建线索", icon: "product-add" }
      },

      {
        path: "mytag",
        name: "myTag-kfm",
        component: () => import("@/views/pms/product/myTag"),
        meta: { title: "我的标签", icon: "product-list" }
      },
      {
        path: "kpi",
        name: "kpi",
        component: () => import("@/views/data/statistics/index"),
        meta: { title: "业绩简报", icon: "product-list" }
      },
      {
        path: "unpaybalance",
        name: "unPayBalance",
        component: () => import("@/views/data/statistics/unPayBalance"),
        meta: { title: "未补齐全款", icon: "product-list" }
      },
      {
        path: "noticeall",
        name: "noticeAll",
        component: () => import("@/views/notice/noticeAll"),
        meta: { title: "公告管理", icon: "product-add" }
      },
      {
        path: "kfmtest",
        name: "kfmtest",
        component: () => import("@/views/kfmHome/kfmtest"),
        meta: { title: "kfmtest", icon: "product-add" }
      }
    ]
  },
  // 客服部所有页面
  {
    path: "/kfhome",
    component: Layout,
    name: "kfHome",
    redirect: "/kfhome/kfh",
    meta: { title: "客服部首页", icon: "product" },
    children: [
      {
        path: "kfh",
        name: "kfh",
        component: () => import("@/views/kfHome/index"),
        meta: { title: "客服部首页", icon: "product-add" }
      },
      {
        path: "product",
        name: "product-kf",
        component: () => import("@/views/pms/product/index"),
        meta: { title: "客服我的学员", icon: "product-list" }
      },
      {
        path: "newclew",
        name: "newClew2",
        component: () => import("@/views/dailyTask/newClew"),
        meta: { title: "待沟通线索", icon: "product-add" }
      },
      {
        path: "chatstu",
        name: "chatStu2",
        component: () => import("@/views/dailyTask/chatStu"),
        meta: { title: "已沟通学员", icon: "product-add" }
      },
      {
        path: "newstu",
        name: "newStu2",
        component: () => import("@/views/dailyTask/newStu"),
        meta: { title: "新增学员", icon: "product-add" }
      },

      {
        path: "unchatstu",
        name: "unChatStu2",
        component: () => import("@/views/dailyTask/unChatStu"),
        meta: { title: "待沟通学员", icon: "product-add" }
      },
      {
        path: "addproduct",
        name: "addProduct2",
        component: () => import("@/views/pms/product/add"),
        meta: { title: "新建线索", icon: "product-add" }
      },
      {
        path: "studetail",
        name: "stuDetail2",
        component: () => import("@/views/pms/product/stuDetail"),
        meta: { title: "学员详情", icon: "product-list" }
      },
      {
        path: "mytag",
        name: "myTag2",
        component: () => import("@/views/pms/product/myTag"),
        meta: { title: "我的标签", icon: "product-list" }
      },
      {
        path: "kpi",
        name: "kpi2",
        component: () => import("@/views/data/statistics/index"),
        meta: { title: "业绩简报", icon: "product-list" }
      },
      {
        path: "unpaybalance",
        name: "unPayBalance2",
        component: () => import("@/views/data/statistics/unPayBalance"),
        meta: { title: "未补齐全款", icon: "product-list" }
      },
      {
        path: "kftest",
        name: "kftest",
        component: () => import("@/views/kfHome/kftest"),
        meta: { title: "kftest", icon: "product-add" }
      }
    ]
  },
  // 学服部主管所有页面
  {
    path: "/xfmhome",
    component: Layout,
    name: "xfmHome",
    redirect: "/xfmhome/xfm",
    meta: { title: "学服部主管首页", icon: "product" },
    children: [
      {
        path: "xfm",
        name: "xfm",
        component: () => import("@/views/xfmHome/index"),
        meta: { title: "学服主管首页", icon: "product-list" }
      },
      {
        path: "newallocate",
        name: "newAllocate-xfm",
        component: () => import("@/views/dailyTask/newAllocate"),
        meta: { title: "新分配学员", icon: "product-add" }
      },
      {
        path: "unconfirmbase",
        name: "unConfirmBase-xfm",
        component: () => import("@/views/dailyTask/unConfirmBase"),
        meta: { title: "基本信息待确认", icon: "product-add" }
      },
      {
        path: "singleunconfirmbase",
        name: "singleUnConfirmBase-xfm",
        component: () => import("@/views/dailyTask/singleUnConfirmBase"),
        meta: { title: "单一学员基本待确认信息", icon: "product-add" }
      },
      {
        path: "selectcourseunconfirm",
        name: "selectCourseUnConfirm-xfm",
        component: () => import("@/views/dailyTask/selectCourseUnConfirm"),
        meta: { title: "审课待提交学员", icon: "product-list" }
      },
      {
        path: "selecting",
        name: "selecting",
        component: () => import("@/views/selectingPage/selecting"),
        meta: { title: "LOP审课中", icon: "product-add" }
      },
      {
        path: "selectunpass",
        name: "selectUnPass",
        component: () => import("@/views/selectingPage/selectUnPass"),
        meta: { title: "审课未通过", icon: "product-add" }
      },
      {
        path: "auditfail",
        name: "auditFail",
        component: () => import("@/views/selectingPage/auditFail"),
        meta: { title: "审课失败", icon: "product-add" }
      },
      {
        path: "confirmauditcourse",
        name: "confirmAuditCourse",
        component: () => import("@/views/selectingPage/confirmAuditCourse"),
        meta: { title: "学员全部信息待确认", icon: "product-add" }
      },
      {
        path: "confirmturn",
        name: "confirmTurn",
        component: () => import("@/views/selectingPage/confirmTurn"),
        meta: { title: "学员转学分确认", icon: "product-add" }
      },
      {
        path: "outlinelist",
        name: "outlineList",
        component: () => import("@/views/outline/outlineList"),
        meta: { title: "审课大纲更新", icon: "product-add" }
      },
      {
        path: "addproduct",
        name: "addProduct-xfm",
        component: () => import("@/views/pms/product/add"),
        meta: { title: "新建线索", icon: "product-add" }
      },
      {
        path: "unbind",
        name: "unBind-xfm",
        component: () => import("@/views/pms/product/unBind"),
        meta: { title: "待分配学员", icon: "product-add" }
      },
      {
        path: "bind",
        name: "bind-xfm",
        component: () => import("@/views/pms/product/bind"),
        meta: { title: "已分配学员", icon: "product-add" }
      },
      {
        path: "xuefumastermystu",
        name: "xuefuMasterMyStu-xfm",
        component: () => import("@/views/pms/product/xuefuMasterMyStu"),
        meta: { title: "学服主管我的学员", icon: "product-list" }
      },
      {
        path: "mytag",
        name: "myTag-xfm",
        component: () => import("@/views/pms/product/myTag"),
        meta: { title: "我的标签", icon: "product-list" }
      },
      {
        path: "noticeall",
        name: "noticeAll-xfm",
        component: () => import("@/views/notice/noticeAll"),
        meta: { title: "公告管理", icon: "product-add" }
      },
      {
        path: "xfmtest",
        name: "xfmtest",
        component: () => import("@/views/xfmHome/xfmtest"),
        meta: { title: "xfmtest", icon: "product-add" }
      }
    ]
  },
  // 学服部所有页面
  {
    path: "/xfhome",
    component: Layout,
    name: "xfHome",
    redirect: "/xfHome/xfh",
    meta: { title: "学服部首页", icon: "product" },
    children: [
      {
        path: "xfh",
        name: "xfh",
        component: () => import("@/views/xfhome/index"),
        meta: { title: "学服部首页", icon: "product-add" }
      },
      {
        path: "newallocate",
        name: "newAllocate-xf",
        component: () => import("@/views/dailyTask/newAllocate"),
        meta: { title: "新分配学员", icon: "product-add" }
      },
      {
        path: "unconfirmbase",
        name: "unConfirmBase-xf",
        component: () => import("@/views/dailyTask/unConfirmBase"),
        meta: { title: "基本信息待确认", icon: "product-add" }
      },
      {
        path: "singleunconfirmbase",
        name: "singleUnConfirmBase-xf",
        component: () => import("@/views/dailyTask/singleUnConfirmBase"),
        meta: { title: "单一学员基本待确认信息", icon: "product-add" }
      },
      {
        path: "selectcourseunconfirm",
        name: "selectCourseUnConfirm-xf",
        component: () => import("@/views/dailyTask/selectCourseUnConfirm"),
        meta: { title: "审课待提交学员", icon: "product-list" }
      },
      {
        path: "selecting",
        name: "selecting-xf",
        component: () => import("@/views/selectingPage/selecting"),
        meta: { title: "LOP审课中", icon: "product-add" }
      },
      {
        path: "selectunpass",
        name: "selectUnPass-xf",
        component: () => import("@/views/selectingPage/selectUnPass"),
        meta: { title: "审课未通过", icon: "product-add" }
      },
      {
        path: "auditfail",
        name: "auditFail-xf",
        component: () => import("@/views/selectingPage/auditFail"),
        meta: { title: "审课失败", icon: "product-add" }
      },
      {
        path: "confirmauditcourse",
        name: "confirmAuditCourse-xf",
        component: () => import("@/views/selectingPage/confirmAuditCourse"),
        meta: { title: "学员全部信息待确认", icon: "product-add" }
      },
      {
        path: "confirmturn",
        name: "confirmTurn-xf",
        component: () => import("@/views/selectingPage/confirmTurn"),
        meta: { title: "学员转学分确认", icon: "product-add" }
      },
      {
        path: "outlinelist",
        name: "outlineList-xf",
        component: () => import("@/views/outline/outlineList"),
        meta: { title: "审课大纲更新", icon: "product-add" }
      },
      {
        path: "addproduct",
        name: "addProduct-xf",
        component: () => import("@/views/pms/product/add"),
        meta: { title: "新建线索", icon: "product-add" }
      },
      {
        path: "uncommit",
        name: "unCommit-xf",
        component: () => import("@/views/pms/product/unCommit"),
        meta: { title: "未提交信息审核", icon: "product-list" }
      },
      {
        path: "xuefumystu",
        name: "xuefuMyStu-xf",
        component: () => import("@/views/pms/product/xuefuMyStu"),
        meta: { title: "学服我的学员", icon: "product-list" }
      },
      {
        path: "mytag",
        name: "myTag-xf",
        component: () => import("@/views/pms/product/myTag"),
        meta: { title: "我的标签", icon: "product-list" }
      },
      {
        path: "xftest",
        name: "xftest",
        component: () => import("@/views/xfHome/xftest"),
        meta: { title: "xftest", icon: "product-add" }
      }
    ]
  },
  // 教务部所有页面
  {
    path: "/coursemanager",
    component: Layout,
    name: "courseManager",
    redirect: "/coursemanager/jwh",
    meta: { title: "教务部", icon: "product" },
    children: [
      {
        path: "jwh",
        name: "jwh",
        component: () => import("@/views/jwHome/index"),
        meta: { title: "教务部首页", icon: "product-list" }
      },
      {
        path: "matchpf",
        name: "matchPF-jw",
        component: () => import("@/views/dailyTask/matchPF"),
        meta: { title: "匹配教授", icon: "product-add" }
      },
      {
        path: "needscorestu",
        name: "needScoreStu",
        component: () => import("@/views/dailyTask/needScoreStu"),
        meta: { title: "需打分学员", icon: "product-list" }
      },
      {
        path: "havescorestu",
        name: "haveScoreStu",
        component: () => import("@/views/pms/product/haveScoreStu"),
        meta: { title: "已打分学员", icon: "product-add" }
      },
      {
        path: "gpapdf",
        name: "gpaPdf",
        component: () => import("@/views/pms/product/gpaPdf"),
        meta: { title: "打印成绩单", icon: "product-add" }
      },
      {
        path: "NewGpaPdf",
        name: "NewGpaPdf",
        component: () => import("@/views/pms/product/NewGpaPdf"),
        meta: { title: "打印成绩单", icon: "product-add" }
      },

      {
        path: "editplan",
        name: "editPlan-jw",
        component: () => import("@/views/dailyTask/editPlan"),
        meta: { title: "编撰大纲", icon: "product-list" }
      },
      {
        path: "storepf",
        name: "storePF",
        component: () => import("@/views/professorManager/storePF"),
        meta: { title: "储备教授", icon: "product-add" }
      },
      {
        path: "csocourse",
        name: "csoCourse",
        component: () => import("@/views/courseManager/csoCourse"),
        meta: { title: "cso课程管理", icon: "product-add" }
      },
      {
        path: "cooperatecourse",
        name: "cooperateCourse",
        component: () => import("@/views/courseManager/cooperateCourse"),
        meta: { title: "合作院校课程管理", icon: "product-add" }
      },
      {
        path: "recruitcourse",
        name: "recruitCourse",
        component: () => import("@/views/courseManager/recruitCourse"),
        meta: { title: "招生院校课程管理", icon: "product-add" }
      },
      {
        path: "independentteach",
        name: "independentTeach",
        component: () => import("@/views/schoolManager/independentTeach"),
        meta: { title: "自主授课", icon: "product-add" }
      },
      {
        path: "unindependentteach",
        name: "unIndependentTeach",
        component: () => import("@/views/schoolManager/unIndependentTeach"),
        meta: { title: "非自主授课", icon: "product-add" }
      }
    ]
  },
  // cso主管所有页面
  {
    path: "/homepage",
    component: Layout,
    name: "homePage",
    redirect: "/homepage/csomasterhome",
    meta: { title: "cso主管", icon: "product" },
    children: [
      // {
      //   path: "xuefuhome",
      //   name: "xuefuHome",
      //   component: () => import("@/views/homePage/xuefuHome"),
      //   meta: { title: "学服首页", icon: "product-list" }
      // },
      {
        path: "xuefumasterhome",
        name: "xuefuMasterHome",
        component: () => import("@/views/homePage/xuefuMasterHome"),
        meta: { title: "学服主管首页", icon: "product-list" }
      },
      {
        path: "kefuhome",
        name: "kefuHome",
        component: () => import("@/views/homePage/kefuHome"),
        meta: { title: "学服首页", icon: "product-list" }
      },
      {
        path: "jiaowuhome",
        name: "jiaowuHome",
        component: () => import("@/views/homePage/jiaowuHome"),
        meta: { title: "教务部首页", icon: "product-list" }
      },
      {
        path: "csomasterhome",
        name: "csoMasterHome",
        component: () => import("@/views/homePage/csoMasterHome"),
        meta: { title: "cso主管首页", icon: "product-list" }
      },
      {
        path: "superadminmystu",
        name: "superAdminMyStu-csom",
        component: () => import("@/views/pms/product/superAdminMyStu"),
        meta: { title: "超级管理员我的学员", icon: "product-list" }
      },
      {
        path: "kpi",
        name: "kpi-csom",
        component: () => import("@/views/data/statistics/index"),
        meta: { title: "业绩简报", icon: "product-list" }
      },
      {
        path: "unpaybalance",
        name: "unPayBalance-csom",
        component: () => import("@/views/data/statistics/unPayBalance"),
        meta: { title: "未补齐全款", icon: "product-list" }
      },
      {
        path: "schoollist",
        name: "schoolList",
        component: () => import("@/views/data/statistics/schoolList"),
        meta: { title: "招生院校统计", icon: "product-list" }
      },
      {
        path: "noticeall",
        name: "noticeAll-csom",
        component: () => import("@/views/notice/noticeAll"),
        meta: { title: "公告管理", icon: "product-add" }
      }
    ]
  },
  // 审课进行中
  {
    path: "/selectingpage",
    component: Layout,
    name: "selectingPage",
    redirect: "/selectingpage/selecting",
    meta: { title: "审课进行中", icon: "product" },
    children: [
      {
        path: "selecting",
        name: "selecting",
        component: () => import("@/views/selectingPage/selecting"),
        meta: { title: "LOP审课中", icon: "product-add" }
      },
      {
        path: "selectunpass",
        name: "selectUnPass",
        component: () => import("@/views/selectingPage/selectUnPass"),
        meta: { title: "审课未通过", icon: "product-add" }
      },
      {
        path: "auditfail",
        name: "auditFail",
        component: () => import("@/views/selectingPage/auditFail"),
        meta: { title: "审课失败", icon: "product-add" }
      },
      {
        path: "confirmauditcourse",
        name: "confirmAuditCourse",
        component: () => import("@/views/selectingPage/confirmAuditCourse"),
        meta: { title: "学员全部信息待确认", icon: "product-add" }
      },
      {
        path: "confirmturn",
        name: "confirmTurn",
        component: () => import("@/views/selectingPage/confirmTurn"),
        meta: { title: "学员转学分确认", icon: "product-add" }
      }
    ]
  },
  //教授管理-储备教授
  {
    path: "/professormanager",
    component: Layout,
    name: "professorManager",
    redirect: "/professormanager/storepf",
    meta: { title: "教授管理", icon: "product" },
    children: [
      {
        path: "storepf",
        name: "storePF",
        component: () => import("@/views/professorManager/storePF"),
        meta: { title: "储备教授", icon: "product-add" }
      }
    ]
  },
  // 缴费标签
  {
    path: "/paycosttag",
    component: Layout,
    name: "payCostTag",
    redirect: "/paycosttag/paycosttag",
    meta: { title: "缴费标签", icon: "product" },
    children: [
      {
        path: "paycosttag",
        name: "payCostTag",
        component: () => import("@/views/payCostTag/index"),
        meta: { title: "缴费标签", icon: "product-add" }
      },
      {
        path: "test2",
        name: "test2",
        component: () => import("@/views/payCostTag/test2"),
        meta: { title: "test2", icon: "product-add" }
      }
    ]
  },
  //课程管理
  {
    path: "/course",
    component: Layout,
    name: "course",
    redirect: "/course/csocourse",
    meta: { title: "课程管理", icon: "product" },
    children: [
      {
        path: "csocourse",
        name: "csoCourse",
        component: () => import("@/views/courseManager/csoCourse"),
        meta: { title: "cso课程管理", icon: "product-add" }
      },
      {
        path: "cooperatecourse",
        name: "cooperateCourse",
        component: () => import("@/views/courseManager/cooperateCourse"),
        meta: { title: "合作院校课程管理", icon: "product-add" }
      },
      {
        path: "recruitcourse",
        name: "recruitCourse",
        component: () => import("@/views/courseManager/recruitCourse"),
        meta: { title: "招生院校课程管理", icon: "product-add" }
      }
    ]
  },
  //院校管理
  {
    path: "/schoolmanager",
    component: Layout,
    name: "schoolManager",
    redirect: "/schoolmanager/independentteach",
    meta: { title: "院校管理", icon: "product" },
    children: [
      {
        path: "independentteach",
        name: "independentTeach",
        component: () => import("@/views/schoolManager/independentTeach"),
        meta: { title: "自主授课", icon: "product-add" }
      },
      {
        path: "unindependentteach",
        name: "unIndependentTeach",
        component: () => import("@/views/schoolManager/unIndependentTeach"),
        meta: { title: "非自主授课", icon: "product-add" }
      }
    ]
  },
  // 系统公告
  {
    path: "/notice",
    component: Layout,
    name: "notice",
    redirect: "/notice/noticeall",
    meta: { title: "系统公告", icon: "product" },
    children: [
      {
        path: "noticeall",
        name: "noticeAll",
        component: () => import("@/views/notice/noticeAll"),
        meta: { title: "公告管理", icon: "product-add" }
      },
      {
        path: "test",
        name: "test",
        component: () => import("@/views/notice/test"),
        meta: { title: "test", icon: "product-add" }
      }
    ]
  },
  // 大纲
  {
    path: "/outline",
    component: Layout,
    name: "outline",
    redirect: "/outline/outlinelist",
    meta: { title: "大纲", icon: "product" },
    children: [
      {
        path: "addoutline",
        name: "addOutline",
        component: () => import("@/views/outline/addOutline"),
        meta: { title: "提交课程大纲", icon: "product-add" }
      },
      {
        path: "outlinelist",
        name: "outlineList",
        component: () => import("@/views/outline/outlineList"),
        meta: { title: "审课大纲更新", icon: "product-add" }
      }
    ]
  },
  // 今日任务
  {
    path: "/dailytask",
    component: Layout,
    name: "dailyTask",
    redirect: "/home",
    meta: { title: "今日任务", icon: "product" },
    children: [
      {
        path: "newclew",
        name: "newClew",
        component: () => import("@/views/dailyTask/newClew"),
        meta: { title: "待沟通线索", icon: "product-add" }
      },
      {
        path: "chatstu",
        name: "chatStu",
        component: () => import("@/views/dailyTask/chatStu"),
        meta: { title: "已沟通学员", icon: "product-add" }
      },
      {
        path: "newstu",
        name: "newStu",
        component: () => import("@/views/dailyTask/newStu"),
        meta: { title: "新增学员", icon: "product-add" }
      },

      {
        path: "unchatstu",
        name: "unChatStu",
        component: () => import("@/views/dailyTask/unChatStu"),
        meta: { title: "待沟通学员", icon: "product-add" }
      },
      {
        path: "newallocate",
        name: "newAllocate",
        component: () => import("@/views/dailyTask/newAllocate"),
        meta: { title: "新分配学员", icon: "product-add" }
      },
      {
        path: "unconfirmbase",
        name: "unConfirmBase",
        component: () => import("@/views/dailyTask/unConfirmBase"),
        meta: { title: "基本信息待确认", icon: "product-add" }
      },
      {
        path: "singleunconfirmbase",
        name: "singleUnConfirmBase",
        component: () => import("@/views/dailyTask/singleUnConfirmBase"),
        meta: { title: "单一学员基本待确认信息", icon: "product-add" }
      },
      {
        path: "matchpf",
        name: "matchPF",
        component: () => import("@/views/dailyTask/matchPF"),
        meta: { title: "匹配教授", icon: "product-add" }
      },
      {
        path: "selectcourseunconfirm",
        name: "selectCourseUnConfirm",
        component: () => import("@/views/dailyTask/selectCourseUnConfirm"),
        meta: { title: "审课待提交学员", icon: "product-list" }
      },
      {
        path: "needscorestu",
        name: "needScoreStu",
        component: () => import("@/views/dailyTask/needScoreStu"),
        meta: { title: "需打分学员", icon: "product-list" }
      },
      //教务部-编撰大纲
      {
        path: "editplan",
        name: "editPlan",
        component: () => import("@/views/dailyTask/editPlan"),
        meta: { title: "编撰大纲", icon: "product-list" }
      }
    ]
  },

  // 数据统计
  {
    path: "/data",
    component: Layout,
    name: "data",
    redirect: "/data/kpi",
    meta: { title: "数据统计", icon: "product" },
    children: [
      {
        path: "kpi",
        name: "kpi",
        component: () => import("@/views/data/statistics/index"),
        meta: { title: "业绩简报", icon: "product-list" }
      },
      {
        path: "unpaybalance",
        name: "unPayBalance",
        component: () => import("@/views/data/statistics/unPayBalance"),
        meta: { title: "未补齐全款", icon: "product-list" }
      },
      {
        path: "schoollist",
        name: "schoolList",
        component: () => import("@/views/data/statistics/schoolList"),
        meta: { title: "招生院校统计", icon: "product-list" }
      }
    ]
  },
  // 学员
  {
    path: "/pms",
    component: Layout,
    // redirect: "/pms/product",
    redirect: "/home",
    name: "pms",
    meta: { title: "商品", icon: "product" },
    children: [
      {
        path: "product",
        name: "product",
        component: () => import("@/views/pms/product/index"),
        meta: { title: "客服我的学员", icon: "product-list" }
      },
      {
        path: "kefumastermystu",
        name: "kefuMasterMyStu",
        component: () => import("@/views/pms/product/kefuMasterMyStu"),
        meta: { title: "客服主管我的学员", icon: "product-list" }
      },
      {
        path: "xuefumystu",
        name: "xuefuMyStu",
        component: () => import("@/views/pms/product/xuefuMyStu"),
        meta: { title: "学服我的学员", icon: "product-list" }
      },
      {
        path: "superadminmystu",
        name: "superAdminMyStu",
        component: () => import("@/views/pms/product/superAdminMyStu"),
        meta: { title: "超级管理员我的学员", icon: "product-list" }
      },
      {
        path: "mytag",
        name: "myTag",
        component: () => import("@/views/pms/product/myTag"),
        meta: { title: "我的标签", icon: "product-list" }
      },
      {
        path: "xuefumytag",
        name: "xuefuMyTag",
        component: () => import("@/views/pms/product/xuefuMyTag"),
        meta: { title: "学服部我的标签", icon: "product-list" }
      },
      {
        path: "uncommit",
        name: "unCommit",
        component: () => import("@/views/pms/product/unCommit"),
        meta: { title: "未提交信息审核", icon: "product-list" }
      },
      {
        path: "xuefumastermystu",
        name: "xuefuMasterMyStu",
        component: () => import("@/views/pms/product/xuefuMasterMyStu"),
        meta: { title: "学服主管我的学员", icon: "product-list" }
      },
      {
        path: "addproduct",
        name: "addProduct",
        component: () => import("@/views/pms/product/add"),
        meta: { title: "新建线索", icon: "product-add" }
      },
      {
        path: "studetail",
        name: "stuDetail",
        component: () => import("@/views/pms/product/stuDetail"),
        meta: { title: "学员详情", icon: "product-add" }
      },
      {
        path: "unbind",
        name: "unBind",
        component: () => import("@/views/pms/product/unBind"),
        meta: { title: "待分配学员", icon: "product-add" }
      },
      {
        path: "kefuUnBind",
        name: "kefuUnBind",
        component: () => import("@/views/pms/product/kefuUnBind"),
        meta: { title: "客服部待分配学员", icon: "product-add" }
      },
      {
        path: "bind",
        name: "bind",
        component: () => import("@/views/pms/product/bind"),
        meta: { title: "已分配学员", icon: "product-add" }
      },
      {
        path: "kefuBind",
        name: "kefuBind",
        component: () => import("@/views/pms/product/kefuBind"),
        meta: { title: "客服部已分配学员", icon: "product-add" }
      },
      {
        path: "havescorestu",
        name: "haveScoreStu",
        component: () => import("@/views/pms/product/haveScoreStu"),
        meta: { title: "已打分学员", icon: "product-add" }
      },
      {
        path: "gpapdf",
        name: "gpaPdf",
        component: () => import("@/views/pms/product/gpaPdf"),
        meta: { title: "打印成绩单", icon: "product-add" }
      },
      {
        path: "NewGpaPdf",
        name: "NewGpaPdf",
        component: () => import("@/views/pms/product/NewGpaPdf"),
        meta: { title: "打印成绩单", icon: "product-add" }
      },
      {
        path: "singletagpage",
        name: "singleTagPage",
        component: () => import("@/views/pms/product/singleTagPage"),
        meta: { title: "单一标签页", icon: "product-add" }
      },
      {
        path: "xuefusingletagpage",
        name: "xuefuSingleTagPage",
        component: () => import("@/views/pms/product/xuefuSingleTagPage"),
        meta: { title: "学服单一标签页", icon: "product-add" }
      },

      {
        path: "updateroduct",
        name: "updateProduct",
        component: () => import("@/views/pms/product/update"),
        meta: { title: "修改商品", icon: "product-add" },
        hidden: true
      },
      {
        path: "productCate",
        name: "productCate",
        component: () => import("@/views/pms/productCate/index"),
        meta: { title: "商品分类", icon: "product-cate" }
      },
      {
        path: "addProductCate",
        name: "addProductCate",
        component: () => import("@/views/pms/productCate/add"),
        meta: { title: "添加商品分类" },
        hidden: true
      },
      {
        path: "updateProductCate",
        name: "updateProductCate",
        component: () => import("@/views/pms/productCate/update"),
        meta: { title: "修改商品分类" },
        hidden: true
      },
      {
        path: "productAttr",
        name: "productAttr",
        component: () => import("@/views/pms/productAttr/index"),
        meta: { title: "商品类型", icon: "product-attr" }
      },
      {
        path: "productAttrList",
        name: "productAttrList",
        component: () => import("@/views/pms/productAttr/productAttrList"),
        meta: { title: "商品属性列表" },
        hidden: true
      },
      {
        path: "addProductAttr",
        name: "addProductAttr",
        component: () => import("@/views/pms/productAttr/addProductAttr"),
        meta: { title: "添加商品属性" },
        hidden: true
      },
      {
        path: "updateProductAttr",
        name: "updateProductAttr",
        component: () => import("@/views/pms/productAttr/updateProductAttr"),
        meta: { title: "修改商品属性" },
        hidden: true
      },
      {
        path: "brand",
        name: "brand",
        component: () => import("@/views/pms/brand/index"),
        meta: { title: "品牌管理", icon: "product-brand" }
      },
      {
        path: "addBrand",
        name: "addBrand",
        component: () => import("@/views/pms/brand/add"),
        meta: { title: "添加品牌" },
        hidden: true
      },
      {
        path: "updateBrand",
        name: "updateBrand",
        component: () => import("@/views/pms/brand/update"),
        meta: { title: "编辑品牌" },
        hidden: true
      }
    ]
  },
  {
    path: "/oms",
    component: Layout,
    redirect: "/oms/order",
    name: "oms",
    meta: { title: "订单", icon: "order" },
    children: [
      {
        path: "order",
        name: "order",
        component: () => import("@/views/oms/order/index"),
        meta: { title: "订单列表", icon: "product-list" }
      },
      {
        path: "orderDetail",
        name: "orderDetail",
        component: () => import("@/views/oms/order/orderDetail"),
        meta: { title: "订单详情" },
        hidden: true
      },
      {
        path: "deliverOrderList",
        name: "deliverOrderList",
        component: () => import("@/views/oms/order/deliverOrderList"),
        meta: { title: "发货列表" },
        hidden: true
      },
      {
        path: "orderSetting",
        name: "orderSetting",
        component: () => import("@/views/oms/order/setting"),
        meta: { title: "订单设置", icon: "order-setting" }
      },
      {
        path: "returnApply",
        name: "returnApply",
        component: () => import("@/views/oms/apply/index"),
        meta: { title: "退货申请处理", icon: "order-return" }
      },
      {
        path: "returnReason",
        name: "returnReason",
        component: () => import("@/views/oms/apply/reason"),
        meta: { title: "退货原因设置", icon: "order-return-reason" }
      },
      {
        path: "returnApplyDetail",
        name: "returnApplyDetail",
        component: () => import("@/views/oms/apply/applyDetail"),
        meta: { title: "退货原因详情" },
        hidden: true
      }
    ]
  },
  {
    path: "/sms",
    component: Layout,
    redirect: "/sms/coupon",
    name: "sms",
    meta: { title: "营销", icon: "sms" },
    children: [
      {
        path: "flash",
        name: "flash",
        component: () => import("@/views/sms/flash/index"),
        meta: { title: "秒杀活动列表", icon: "sms-flash" }
      },
      {
        path: "flashSession",
        name: "flashSession",
        component: () => import("@/views/sms/flash/sessionList"),
        meta: { title: "秒杀时间段列表" },
        hidden: true
      },
      {
        path: "selectSession",
        name: "selectSession",
        component: () => import("@/views/sms/flash/selectSessionList"),
        meta: { title: "秒杀时间段选择" },
        hidden: true
      },
      {
        path: "flashProductRelation",
        name: "flashProductRelation",
        component: () => import("@/views/sms/flash/productRelationList"),
        meta: { title: "秒杀商品列表" },
        hidden: true
      },
      {
        path: "coupon",
        name: "coupon",
        component: () => import("@/views/sms/coupon/index"),
        meta: { title: "优惠券列表", icon: "sms-coupon" }
      },
      {
        path: "addCoupon",
        name: "addCoupon",
        component: () => import("@/views/sms/coupon/add"),
        meta: { title: "添加优惠券" },
        hidden: true
      },
      {
        path: "updateCoupon",
        name: "updateCoupon",
        component: () => import("@/views/sms/coupon/update"),
        meta: { title: "修改优惠券" },
        hidden: true
      },
      {
        path: "couponHistory",
        name: "couponHistory",
        component: () => import("@/views/sms/coupon/history"),
        meta: { title: "优惠券领取详情" },
        hidden: true
      },
      {
        path: "brand",
        name: "homeBrand",
        component: () => import("@/views/sms/brand/index"),
        meta: { title: "品牌推荐", icon: "product-brand" }
      },
      {
        path: "new",
        name: "homeNew",
        component: () => import("@/views/sms/new/index"),
        meta: { title: "新品推荐", icon: "sms-new" }
      },
      {
        path: "hot",
        name: "homeHot",
        component: () => import("@/views/sms/hot/index"),
        meta: { title: "人气推荐", icon: "sms-hot" }
      },
      {
        path: "subject",
        name: "homeSubject",
        component: () => import("@/views/sms/subject/index"),
        meta: { title: "专题推荐", icon: "sms-subject" }
      },
      {
        path: "advertise",
        name: "homeAdvertise",
        component: () => import("@/views/sms/advertise/index"),
        meta: { title: "广告列表", icon: "sms-ad" }
      },
      {
        path: "addAdvertise",
        name: "addHomeAdvertise",
        component: () => import("@/views/sms/advertise/add"),
        meta: { title: "添加广告" },
        hidden: true
      },
      {
        path: "updateAdvertise",
        name: "updateHomeAdvertise",
        component: () => import("@/views/sms/advertise/update"),
        meta: { title: "编辑广告" },
        hidden: true
      }
    ]
  },
  {
    path: "/ums",
    component: Layout,
    redirect: "/ums/admin",
    name: "ums",
    meta: { title: "权限", icon: "ums" },
    children: [
      {
        path: "admin",
        name: "admin",
        component: () => import("@/views/ums/admin/index"),
        meta: { title: "用户列表", icon: "ums-admin" }
      },
      // //权限相关页面，交付的时候不展示
      // {
      //   path: "role",
      //   name: "role",
      //   component: () => import("@/views/ums/role/index"),
      //   meta: { title: "角色列表", icon: "ums-role" }
      // },
      // {
      //   path: "allocMenu",
      //   name: "allocMenu",
      //   component: () => import("@/views/ums/role/allocMenu"),
      //   meta: { title: "分配菜单" },
      //   hidden: true
      // },
      // {
      //   path: "allocResource",
      //   name: "allocResource",
      //   component: () => import("@/views/ums/role/allocResource"),
      //   meta: { title: "分配资源" },
      //   hidden: true
      // },
      // {
      //   path: "menu",
      //   name: "menu",
      //   component: () => import("@/views/ums/menu/index"),
      //   meta: { title: "菜单列表", icon: "ums-menu" }
      // },
      // {
      //   path: "addMenu",
      //   name: "addMenu",
      //   component: () => import("@/views/ums/menu/add"),
      //   meta: { title: "添加菜单" },
      //   hidden: true
      // },
      // {
      //   path: "updateMenu",
      //   name: "updateMenu",
      //   component: () => import("@/views/ums/menu/update"),
      //   meta: { title: "修改菜单" },
      //   hidden: true
      // },
      // {
      //   path: "resource",
      //   name: "resource",
      //   component: () => import("@/views/ums/resource/index"),
      //   meta: { title: "资源列表", icon: "ums-resource" }
      // },
      // {
      //   path: "resourceCategory",
      //   name: "resourceCategory",
      //   component: () => import("@/views/ums/resource/categoryList"),
      //   meta: { title: "资源分类" },
      //   hidden: true
      // }
    ]
  },
  { path: "*", redirect: "/404", hidden: true }
];

export default new Router({
  // mode: 'history', //后端支持可开
  scrollBehavior: () => ({ y: 0 }),
  routes: constantRouterMap
});
